#!/bin/sh

MASTER_PAGE_ESXI_UPDATE_RESULT_OK=0
MASTER_PAGE_ESXI_UPDATE_RESULT_ERROR=1
MASTER_PAGE_ESXI_UPDATE_RESULT_CODE=${MASTER_PAGE_ESXI_UPDATE_RESULT_ERROR}

MASTER_PAGE_ESXI_UPDATE_RESULT_ROLLING=0
MASTER_PAGE_ESXI_UPDATE_RESULT_MSG=""

master_page_esxi_update(){
    debug_print 'in function "master_page_esxi_update"'
    debug_print "sc_id='${to_be_updated_sc_id}'"
    
    local item_number=2
    local menu_list=""
    for (( i=1; i<=$item_number; i=i+1 ))
    do
        eval menu_item=\$MASTER_PAGE_ESXI_UPDATE_ITEM_$i
        menu_list="$menu_list '$i' '$menu_item'"
    done
    
    tp_menu_ok_cancel \
        "${MASTER_PAGE_ESXI_UPDATE_TITLE}" \
        "${MASTER_PAGE_ESXI_UPDATE_TEXT}" \
        "${MASTER_PAGE_ESXI_UPDATE_LABEL_OK}" \
        "${MASTER_PAGE_ESXI_UPDATE_LABEL_CANCEL}" \
        "$menu_list" \
        $item_number

    MASTER_PAGE_ESXI_UPDATE_RESULT_CODE=$MASTER_PAGE_ESXI_UPDATE_RESULT_OK
    if [ "${TP_MENU_OK_CANCEL_RESULT_CODE}" == "${TP_MENU_OK_CANCEL_RESULT_CANCEL}" ]; then
        MASTER_PAGE_ESXI_UPDATE_RESULT_ROLLING=-1
        return
    fi
    
    slave_esxi_removed=0
    local pages_array=""
    
    case ${TP_MENU_OK_CANCEL_RESULT_SELECT} in
        1) pages_array="master_page_esxi_info_update" ;;
        2) pages_array="master_page_esxi_remove" ;;
        *) ;;
    esac
    pages_roller "${pages_array}"

    if [ "$slave_esxi_removed" == "1" ]; then
        MASTER_PAGE_ESXI_UPDATE_RESULT_CODE=$MASTER_PAGE_ESXI_UPDATE_RESULT_OK
        MASTER_PAGE_ESXI_UPDATE_RESULT_ROLLING=-1
    else
        MASTER_PAGE_ESXI_UPDATE_RESULT_CODE=$MASTER_PAGE_ESXI_UPDATE_RESULT_OK
        MASTER_PAGE_ESXI_UPDATE_RESULT_ROLLING=0
    fi
}